<?php
class ModelBlogArticle extends Model {
	public function updateViewed($article_id) {
		$this->db->query("UPDATE " . DB_PREFIX . "newsblog_article SET viewed = (viewed + 1) WHERE article_id = '" . (int)$article_id . "'");

	}
	public function updateComment($article_id) {

		$query= "SELECT COUNT(*) AS total_comment FROM " . DB_PREFIX . "newsblog_article_comment WHERE article_id = '" . (int)$article_id . "' AND status = '1'";

		$sql = $this->db->query($query);
		$comment_count = $sql->row['total_comment'];
		return $comment_count;

	}

	public function getArticleCategory($article_id) {
		$query = $this->db->query("SELECT ptc.category_id, ptc.article_id, c.image as image, d.name as category_name,
		(select price from " . DB_PREFIX . "newsblog_article where article_id='" . (int)$article_id . "') as price,
		(select name from " . DB_PREFIX . "newsblog_article_description where article_id='" . (int)$article_id . "') as name,
        (SELECT price FROM " . DB_PREFIX . "newsblog_article_special ps WHERE ps.article_id = '" . (int)$article_id . "' AND ps.customer_group_id = '" . (int)$this->config->get('config_customer_group_id') . "' AND ((ps.date_start = '0000-00-00' OR ps.date_start < NOW()) AND (ps.date_end = '0000-00-00' OR ps.date_end > NOW())) ORDER BY ps.priority ASC, ps.price ASC LIMIT 1) AS special

		FROM " . DB_PREFIX . "newsblog_article_to_category ptc

		LEFT JOIN " . DB_PREFIX . "category c ON (c.category_id = ptc.category_id)
		LEFT JOIN " . DB_PREFIX . "category_description d ON (d.category_id = ptc.category_id)

		WHERE ptc.article_id = '" . (int)$article_id . "'");

		if ($query->num_rows) {
			return $query->row;
		} else {
			return false;
		}
	}

	public function getArticle($article_id) {
		$query = $this->db->query("SELECT DISTINCT *, pd.name AS name, p.image,
		p.sort_order

		FROM " . DB_PREFIX . "newsblog_article p
		LEFT JOIN " . DB_PREFIX . "newsblog_article_description pd ON (p.article_id = pd.article_id)
		LEFT JOIN " . DB_PREFIX . "newsblog_article_to_store p2s ON (p.article_id = p2s.article_id)
		

		WHERE p.article_id = '" . (int)$article_id . "' AND
		pd.language_id = '" . (int)$this->config->get('config_language_id') . "' AND
		p.status = '1' AND		
		p2s.store_id = '" . (int)$this->config->get('config_store_id') . "'");

		if ($query->num_rows) {
			return array(
				'article_id'       => $query->row['article_id'],
				'name'             => $query->row['name'],
				'preview'      	   => $query->row['preview'],
				'description'      => $query->row['description'],
				'meta_title'       => $query->row['meta_title'],
				'article_author'   => $query->row['article_author'],
				'meta_description' => $query->row['meta_description'],
				'meta_keyword'     => $query->row['meta_keyword'],
				'tag'              => $query->row['tag'],
				'image'            => $query->row['image'],
				'date_available'   => $query->row['date_available'],
				'sort_order'       => $query->row['sort_order'],
				'status'           => $query->row['status'],
				'date_modified'    => $query->row['date_modified']
			);
		} else {
			return false;
		}

	}

	public function getArticles($data = array()) {
		
		$sql = "SELECT a.article_id, a.image, a.status" ." FROM " . DB_PREFIX . "newsblog_article a";

		$sql .= " LEFT JOIN " . DB_PREFIX . "newsblog_article_description ad ON (a.article_id = ad.article_id) 
		LEFT JOIN " . DB_PREFIX . "newsblog_article_to_store a2s ON (a.article_id = a2s.article_id)
		LEFT JOIN " . DB_PREFIX . "newsblog_article_to_category a2c ON (a.article_id = a2c.article_id)
		WHERE ad.language_id = '" . (int)$this->config->get('config_language_id') . "' AND
		a.status = '1' AND		
		a2s.store_id = '" . (int)$this->config->get('config_store_id') . "'";


		/*$sql = "SELECT a.article_id";

		if (!empty($data['filter_category_id']) || !empty($data['filter_categories'])) {
			if (!empty($data['filter_sub_category'])) {
				$sql .= " FROM " . DB_PREFIX . "newsblog_category_path cp LEFT JOIN " . DB_PREFIX . "newsblog_article_to_category a2c ON (cp.category_id = a2c.category_id)";
			} else {
				$sql .= " FROM " . DB_PREFIX . "newsblog_article_to_category a2c";
			}

				$sql .= " LEFT JOIN " . DB_PREFIX . "newsblog_article a ON (a2c.article_id = a.article_id)";

		} else {
			$sql .= " FROM " . DB_PREFIX . "newsblog_article a";
		}

		$sql .= " LEFT JOIN " . DB_PREFIX . "newsblog_article_description ad ON (a.article_id = ad.article_id)
		LEFT JOIN " . DB_PREFIX . "newsblog_article_to_store a2s ON (a.article_id = a2s.article_id)

		WHERE ad.language_id = '" . (int)$this->config->get('config_language_id') . "' AND
		a.status = '1' AND
		a.date_available <= NOW() AND
		a2s.store_id = '" . (int)$this->config->get('config_store_id') . "'";

		if (!empty($data['filter_category_id'])) {
			if (!empty($data['filter_sub_category'])) {
				$sql .= " AND cp.path_id = '" . (int)$data['filter_category_id'] . "'";
			} else {
				$sql .= " AND a2c.category_id = '" . (int)$data['filter_category_id'] . "'";
			}
		}*/

		/*if (!empty($data['filter_categories'])) {
			if (!empty($data['filter_sub_category'])) {
				$sql .= " AND cp.path_id in (" . implode(',',$data['filter_categories']) . ")";
			} else {
				$sql .= " AND a2c.category_id in (" . implode(',',$data['filter_categories']) . ")";
			}
		}*/

		$sql .= " GROUP BY a.article_id";

		if (isset($data['sort'])) {
			if ($data['sort'] == 'ad.name') {
				$sql .= " ORDER BY LCASE(" . $data['sort'] . ")";
			} else {
				$sql .= " ORDER BY " . $data['sort'];
			}
		} else {
			$sql .= " ORDER BY a.sort_order";
		}

		if (isset($data['order'])) {
			$sql .= " ".$data['order'];
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 10;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$article_data = array();	

		$query = $this->db->query($sql);
		foreach ($query->rows as $result) {
			$article_data[$result['article_id']] = $this->getArticle($result['article_id']);
		}

		return $article_data;
	}

	// public function getArticleAttributes($article_id) {
	// 	$article_attribute_group_data = array();

	// 	$article_attribute_group_query = $this->db->query("SELECT ag.attribute_group_id, agd.name FROM " . DB_PREFIX . "newsblog_article_attribute pa LEFT JOIN " . DB_PREFIX . "attribute a ON (pa.attribute_id = a.attribute_id) LEFT JOIN " . DB_PREFIX . "attribute_group ag ON (a.attribute_group_id = ag.attribute_group_id) LEFT JOIN " . DB_PREFIX . "attribute_group_description agd ON (ag.attribute_group_id = agd.attribute_group_id) WHERE pa.article_id = '" . (int)$article_id . "' AND agd.language_id = '" . (int)$this->config->get('config_language_id') . "' GROUP BY ag.attribute_group_id ORDER BY ag.sort_order, agd.name");

	// 	foreach ($article_attribute_group_query->rows as $article_attribute_group) {
	// 		$article_attribute_data = array();

	// 		$article_attribute_query = $this->db->query("SELECT a.attribute_id, ad.name, pa.text FROM " . DB_PREFIX . "newsblog_article_attribute pa LEFT JOIN " . DB_PREFIX . "attribute a ON (pa.attribute_id = a.attribute_id) LEFT JOIN " . DB_PREFIX . "attribute_description ad ON (a.attribute_id = ad.attribute_id) WHERE pa.article_id = '" . (int)$article_id . "' AND a.attribute_group_id = '" . (int)$article_attribute_group['attribute_group_id'] . "' AND ad.language_id = '" . (int)$this->config->get('config_language_id') . "' AND pa.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY a.sort_order, ad.name");

	// 		foreach ($article_attribute_query->rows as $article_attribute) {
	// 			$article_attribute_data[] = array(
	// 				'attribute_id' => $article_attribute['attribute_id'],
	// 				'name'         => $article_attribute['name'],
	// 				'text'         => $article_attribute['text']
	// 			);
	// 		}

	// 		$article_attribute_group_data[] = array(
	// 			'attribute_group_id' => $article_attribute_group['attribute_group_id'],
	// 			'name'               => $article_attribute_group['name'],
	// 			'attribute'          => $article_attribute_data
	// 		);
	// 	}

	// 	return $article_attribute_group_data;
	// }

	// public function getArticleOptions($article_id) {
	// 	$article_option_data = array();

	// 	$article_option_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "newsblog_article_option po LEFT JOIN `" . DB_PREFIX . "option` o ON (po.option_id = o.option_id) LEFT JOIN " . DB_PREFIX . "option_description od ON (o.option_id = od.option_id) WHERE po.article_id = '" . (int)$article_id . "' AND od.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY o.sort_order");

	// 	foreach ($article_option_query->rows as $article_option) {
	// 		$article_option_value_data = array();

	// 		$article_option_value_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "newsblog_article_option_value pov LEFT JOIN " . DB_PREFIX . "option_value ov ON (pov.option_value_id = ov.option_value_id) LEFT JOIN " . DB_PREFIX . "option_value_description ovd ON (ov.option_value_id = ovd.option_value_id) WHERE pov.article_id = '" . (int)$article_id . "' AND pov.article_option_id = '" . (int)$article_option['article_option_id'] . "' AND ovd.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY ov.sort_order");

	// 		foreach ($article_option_value_query->rows as $article_option_value) {
	// 			$article_option_value_data[] = array(
	// 				'article_option_value_id' => $article_option_value['article_option_value_id'],
	// 				'option_value_id'         => $article_option_value['option_value_id'],
	// 				'name'                    => $article_option_value['name'],
	// 				'image'                   => $article_option_value['image'],
	// 				'quantity'                => $article_option_value['quantity'],
	// 				'subtract'                => $article_option_value['subtract'],
	// 				'price'                   => $article_option_value['price'],
	// 				'price_prefix'            => $article_option_value['price_prefix'],
	// 				'weight'                  => $article_option_value['weight'],
	// 				'weight_prefix'           => $article_option_value['weight_prefix']
	// 			);
	// 		}

	// 		$article_option_data[] = array(
	// 			'article_option_id'    => $article_option['article_option_id'],
	// 			'article_option_value' => $article_option_value_data,
	// 			'option_id'            => $article_option['option_id'],
	// 			'name'                 => $article_option['name'],
	// 			'type'                 => $article_option['type'],
	// 			'value'                => $article_option['value'],
	// 			'required'             => $article_option['required']
	// 		);
	// 	}

	// 	return $article_option_data;
	// }

	// public function getArticleDiscounts($article_id) {
	// 	$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "newsblog_article_discount WHERE article_id = '" . (int)$article_id . "' AND customer_group_id = '" . (int)$this->config->get('config_customer_group_id') . "' AND quantity > 1 AND ((date_start = '0000-00-00' OR date_start < NOW()) AND (date_end = '0000-00-00' OR date_end > NOW())) ORDER BY quantity ASC, priority ASC, price ASC");

	// 	return $query->rows;
	// }

	public function getArticleImages($article_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "newsblog_article_image WHERE article_id = '" . (int)$article_id . "' ORDER BY sort_order ASC");

		return $query->rows;
	}

	// public function getArticleRelated($article_id) {
	// 	$article_data = array();

	// 	$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "newsblog_article_related pr
	// 	LEFT JOIN " . DB_PREFIX . "newsblog_article p ON (pr.related_id = p.article_id)
	// 	LEFT JOIN " . DB_PREFIX . "newsblog_article_to_store p2s ON (p.article_id = p2s.article_id)
	// 	WHERE pr.article_id = '" . (int)$article_id . "' AND pr.type=1 AND p.status = '1' AND p.date_available <= NOW() AND p2s.store_id = '" . (int)$this->config->get('config_store_id') . "'");

	// 	foreach ($query->rows as $result) {
	// 		$article_data[$result['related_id']] = $this->getArticle($result['related_id']);
	// 	}

	// 	return $article_data;
	// }

	// public function getArticleRelatedProducts($article_id) {
	// 	$product_data = array();

	// 	$query = $this->db->query("SELECT p.product_id FROM " . DB_PREFIX . "newsblog_article_related pr
	// 	LEFT JOIN " . DB_PREFIX . "product p ON (pr.related_id = p.product_id)
	// 	LEFT JOIN " . DB_PREFIX . "product_to_store p2s ON (p.product_id = p2s.product_id)
	// 	WHERE pr.article_id = '" . (int)$article_id . "' AND pr.type=2 AND p.status = '1' AND p.date_available <= NOW() AND p2s.store_id = '" . (int)$this->config->get('config_store_id') . "'");

	// 	foreach ($query->rows as $result) {
	// 		$product_data[$result['product_id']] = $this->model_catalog_product->getProduct($result['product_id']);
	// 	}

	// 	return $product_data;
	// }

	// public function getArticleLayoutId($article_id) {
	// 	$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "newsblog_article_to_layout WHERE article_id = '" . (int)$article_id . "' AND store_id = '" . (int)$this->config->get('config_store_id') . "'");

	// 	if ($query->num_rows) {
	// 		return $query->row['layout_id'];
	// 	} else {
	// 		return 0;
	// 	}
	// }

	public function getCategories($article_id) {
		$query = $this->db->query("SELECT c.category_id, c.article_id, nc.name, nc.status  FROM " . DB_PREFIX . "newsblog_article_to_category  c
			LEFT JOIN " . DB_PREFIX . "newsblog_category nc ON (c.category_id = nc.category_id)
			WHERE c.article_id = '" . (int)$article_id . "' AND nc.status = '1'");

		return $query->rows;
	}

	public function getCategoriesName($article_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "newsblog_category WHERE category_id = '" . (int)$article_id . "'");

		return $query->row['name'];
	}

	public function getTotalArticles($data = array()) {
		$sql = "SELECT COUNT(DISTINCT p.article_id) AS total";

		if (!empty($data['filter_category_id'])) {
			if (!empty($data['filter_sub_category'])) {
				$sql .= " FROM " . DB_PREFIX . "category_path cp LEFT JOIN " . DB_PREFIX . "newsblog_article_to_category p2c ON (cp.category_id = p2c.category_id)";
			} else {
				$sql .= " FROM " . DB_PREFIX . "newsblog_article_to_category p2c";
			}

			if (!empty($data['filter_filter'])) {
				$sql .= " LEFT JOIN " . DB_PREFIX . "newsblog_article_filter pf ON (p2c.article_id = pf.article_id) LEFT JOIN " . DB_PREFIX . "newsblog_article p ON (pf.article_id = p.article_id)";
			} else {
				$sql .= " LEFT JOIN " . DB_PREFIX . "newsblog_article p ON (p2c.article_id = p.article_id)";
			}
		} else {
			$sql .= " FROM " . DB_PREFIX . "newsblog_article p";
		}

		$sql .= " LEFT JOIN " . DB_PREFIX . "newsblog_article_description pd ON (p.article_id = pd.article_id) LEFT JOIN " . DB_PREFIX . "newsblog_article_to_store p2s ON (p.article_id = p2s.article_id) WHERE pd.language_id = '" . (int)$this->config->get('config_language_id') . "' AND p.status = '1' AND p.date_available <= NOW() AND p2s.store_id = '" . (int)$this->config->get('config_store_id') . "'";

		if (!empty($data['filter_category_id'])) {
			if (!empty($data['filter_sub_category'])) {
				$sql .= " AND cp.path_id = '" . (int)$data['filter_category_id'] . "'";
			} else {
				$sql .= " AND p2c.category_id = '" . (int)$data['filter_category_id'] . "'";
			}

			if (!empty($data['filter_filter'])) {
				$implode = array();

				$filters = explode(',', $data['filter_filter']);

				foreach ($filters as $filter_id) {
					$implode[] = (int)$filter_id;
				}

				$sql .= " AND pf.filter_id IN (" . implode(',', $implode) . ")";
			}
		}

		if (!empty($data['filter_name']) || !empty($data['filter_tag'])) {
			$sql .= " AND (";

			if (!empty($data['filter_name'])) {
				$implode = array();

				$words = explode(' ', trim(preg_replace('/\s+/', ' ', $data['filter_name'])));

				foreach ($words as $word) {
					$implode[] = "pd.name LIKE '%" . $this->db->escape($word) . "%'";
				}

				if ($implode) {
					$sql .= " " . implode(" AND ", $implode) . "";
				}

				if (!empty($data['filter_description'])) {
					$sql .= " OR pd.description LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
				}
			}

			if (!empty($data['filter_name']) && !empty($data['filter_tag'])) {
				$sql .= " OR ";
			}

			if (!empty($data['filter_tag'])) {
				$sql .= "pd.tag LIKE '%" . $this->db->escape(utf8_strtolower($data['filter_tag'])) . "%'";
			}

			$sql .= ")";
		}


		$query = $this->db->query($sql);

		return $query->row['total'];
	}

	// public function getProfile($article_id, $recurring_id) {
	// 	 return $this->db->query("SELECT * FROM `" . DB_PREFIX . "recurring` `p` JOIN `" . DB_PREFIX . "newsblog_article_recurring` `pp` ON `pp`.`recurring_id` = `p`.`recurring_id` AND `pp`.`article_id` = " . (int)$article_id . " WHERE `pp`.`recurring_id` = " . (int)$recurring_id . " AND `status` = 1 AND `pp`.`customer_group_id` = " . (int)$this->config->get('config_customer_group_id'))->row;
	// }

	// public function getProfiles($article_id) {
	// 	return $this->db->query("SELECT `pd`.* FROM `" . DB_PREFIX . "newsblog_article_recurring` `pp` JOIN `" . DB_PREFIX . "recurring_description` `pd` ON `pd`.`language_id` = " . (int)$this->config->get('config_language_id') . " AND `pd`.`recurring_id` = `pp`.`recurring_id` JOIN `" . DB_PREFIX . "recurring` `p` ON `p`.`recurring_id` = `pd`.`recurring_id` WHERE `article_id` = " . (int)$article_id . " AND `status` = 1 AND `customer_group_id` = " . (int)$this->config->get('config_customer_group_id') . " ORDER BY `sort_order` ASC")->rows;
	// }

	// public function getTotalarticleSpecials() {
	// 	$query = $this->db->query("SELECT COUNT(DISTINCT ps.article_id) AS total FROM " . DB_PREFIX . "newsblog_article_special ps LEFT JOIN " . DB_PREFIX . "newsblog_article p ON (ps.article_id = p.article_id) LEFT JOIN " . DB_PREFIX . "newsblog_article_to_store p2s ON (p.article_id = p2s.article_id) WHERE p.status = '1' AND p.date_available <= NOW() AND p2s.store_id = '" . (int)$this->config->get('config_store_id') . "' AND ps.customer_group_id = '" . (int)$this->config->get('config_customer_group_id') . "' AND ((ps.date_start = '0000-00-00' OR ps.date_start < NOW()) AND (ps.date_end = '0000-00-00' OR ps.date_end > NOW()))");

	// 	if (isset($query->row['total'])) {
	// 		return $query->row['total'];
	// 	} else {
	// 		return 0;
	// 	}
	// }

	public function getArticleMainCategoryId($article_id) {
		$query = $this->db->query("SELECT category_id FROM " . DB_PREFIX . "newsblog_article_to_category WHERE article_id = '" . (int)$article_id . "' order by main_category desc LIMIT 1");

		return ($query->num_rows ? (int)$query->row['category_id'] : 0);
	}

	public function getPostComments($article_id) {
		$sql = "SELECT DISTINCT * FROM " . DB_PREFIX . "newsblog_article_comment WHERE article_id = '" . (int)$article_id . "' AND status = '1' ";
		$result = $this->db->query($sql);
		return $result->rows;
	}
	public function getBlogComments($article_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "newsblog_article_comment bc LEFT JOIN " . DB_PREFIX . "newsblog_article_description bcd ON (bc.article_id = bcd.article_id) WHERE  bc.status = '1'  ORDER BY bc.date_added DESC");

		return $query->rows;
	}

	public function addReview($data) {
		$sql = "INSERT INTO " . DB_PREFIX . "newsblog_article_comment "
        . "SET article_id = '" . $this->db->escape($data['article_id']) . "',
        		author = '" . $this->db->escape($data['author']) . "',
        		email = '" . $this->db->escape($data['email']) . "',
        		comment_text = '" . $this->db->escape($data['comment_text']) . "',
        	 	date_added = NOW() ";
						return $this->db->query($sql);
		}

    public function getUser($user_id) {
        $query = $this->db->query("SELECT *, (SELECT ug.name FROM `" . DB_PREFIX . "user_group` ug WHERE ug.user_group_id = u.user_group_id) AS user_group FROM `" . DB_PREFIX . "user` u WHERE u.user_id = '" . (int)$user_id . "'");

        return $query->row;
    }
}
